/*
 * Decompiled with CFR 0.152.
 */
package kz.uchet.signUtil;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.concurrent.CountDownLatch;
import java.util.function.Function;
import javafx.application.Platform;
import javax.security.auth.x500.X500Principal;
import javax.swing.UIManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kz.gov.pki.kalkan.Storage;
import kz.gov.pki.kalkan.asn1.x509.X509Name;
import kz.gov.pki.kalkan.exception.KalkanException;
import kz.gov.pki.kalkan.exception.OCSPCode;
import kz.gov.pki.kalkan.jce.exception.ExtCertPathValidatorException;
import kz.gov.pki.kalkan.jce.provider.KalkanProvider;
import kz.gov.pki.kalkan.jce.provider.cms.CMSException;
import kz.gov.pki.kalkan.jce.provider.cms.CMSSignedData;
import kz.gov.pki.kalkan.jce.provider.cms.SignerInformation;
import kz.gov.pki.kalkan.pkix.checker.KNCAOCSPChecker;
import kz.gov.pki.kalkan.tsp.TSPException;
import kz.gov.pki.kalkan.tsp.TimeStampToken;
import kz.gov.pki.kalkan.xmldsig.KncaXS;
import kz.gov.pki.provider.exception.ProviderUtilException;
import kz.gov.pki.provider.exception.ProviderUtilExceptionCode;
import kz.gov.pki.provider.utils.CMSUtil;
import kz.gov.pki.provider.utils.KeyStoreUtil;
import kz.gov.pki.provider.utils.PKIXUtil;
import kz.gov.pki.provider.utils.TSPUtil;
import kz.gov.pki.provider.utils.X509Util;
import kz.gov.pki.provider.utils.XMLUtil;
import kz.gov.pki.provider.utils.model.SigningEntity;
import kz.gov.pki.provider.utils.model.TSAProfile;
import kz.gov.pki.provider.utils.verifier.VerifierFlags;
import kz.gov.pki.reference.KNCACertificateType;
import kz.gov.pki.reference.KNCAServiceRequestMethod;
import kz.gov.pki.reference.KalkanHashAlgorithm;
import kz.gov.pki.reference.KeyStoreEntry;
import kz.gov.pki.reference.TSAPolicy;
import kz.uchet.signUtil.BundleLog;
import kz.uchet.signUtil.BundleProvider;
import kz.uchet.signUtil.gui.dialog.SignerDialog;
import kz.uchet.signUtil.gui.fx.JavaFXThread;
import kz.uchet.signUtil.types.ClientException;
import kz.uchet.signUtil.types.FileExtension;
import kz.uchet.signUtil.types.FileInfo;
import kz.uchet.signUtil.types.ResponseForJS;
import kz.uchet.signUtil.types.ResponseMessage;
import kz.uchet.signUtil.types.SignerInfo;
import kz.uchet.signUtil.types.StorageInfo;
import kz.uchet.signUtil.types.VerificationResult;
import org.json.JSONObject;
import org.w3c.dom.Document;

public class CommonUtils {
    private Function keyInfoService;
    private Function keyInfoSetterService;
    private Locale locale_ru = new Locale("ru");
    private Locale locale_kk = new Locale("kk");
    private Locale locale = this.locale_ru;
    private Collection<X509Certificate> caCertList;
    private Map<X500Principal, X509Certificate> caCertsMap;
    VerifierFlags sigVerifierFlags = new VerifierFlags("SIGNATURE");
    DateFormat df = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
    private JavaFXThread javaFXThread;

    public void setKeyInfoServices(Function keyInfoService) {
        this.keyInfoService = keyInfoService;
    }

    public void setKeyInfoSetterService(Function keyInfoSetterService) {
        this.keyInfoSetterService = keyInfoSetterService;
    }

    public String test(String name) {
        return "true" + name;
    }

    public String getVersion(String name) {
        ResponseForJS responseForJS = new ResponseForJS("200");
        responseForJS.setMessage("1.5");
        return this.getJson(responseForJS);
    }

    public CommonUtils() {
        String osname = System.getProperty("os.name").toLowerCase();
        this.df.setTimeZone(TimeZone.getTimeZone("Asia/Almaty"));
        BundleLog.LOG.info("osname " + osname);
        this.javaFXThread = new JavaFXThread(this.locale);
        this.locale_ru = new Locale("ru");
        this.locale_kk = new Locale("kk");
        this.sigVerifierFlags = new VerifierFlags("SIGNATURE");
        this.df = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        this.locale = this.locale_ru;
        this.javaFXThread = new JavaFXThread(this.locale);
        try {
            if (osname.contains("mac os")) {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            } else {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            BundleLog.LOG.info("osname " + osname);
        }
        catch (Exception var3) {
            BundleLog.LOG.error(var3.getMessage(), var3);
        }
    }

    public String signXml(String storageName, String keyTypeValue, String xml, String tbsElementXPath, String signatureParentElementXPath) {
        ResponseMessage<String> responseMessage = new ResponseMessage<String>("500");
        try {
            StorageInfo storageInfo = new StorageInfo(storageName, this.keyInfoService, this.keyInfoSetterService);
            KNCACertificateType keyType = null;
            try {
                keyType = KNCACertificateType.valueOf((String)keyTypeValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
            HashMap<String, String> titles = new HashMap<String, String>();
            titles.put("title", "label.signerDialog.xmlTitle");
            SignerDialog signerDialog = new SignerDialog(storageInfo, keyType, titles);
            signerDialog.setVisible(true);
            if (signerDialog.getDoSign()) {
                KeyStore keyStore = KeyStoreUtil.getKeyStore((Storage)storageInfo.getStorage(), (String)storageInfo.getContainer(), (char[])storageInfo.getPassword(), (Provider)BundleProvider.KALKAN.getProvider());
                SigningEntity signingEntity = KeyStoreUtil.getSigningEntity((KeyStore)keyStore, (String)storageInfo.getAlias(), (char[])storageInfo.getPassword());
                responseMessage.setResponseObject(XMLUtil.createXmlSignature((SigningEntity)signingEntity, (String)xml, (String)tbsElementXPath, (String)signatureParentElementXPath, (Provider)BundleProvider.KALKAN.getProvider()));
                responseMessage.setCode("200");
                if (storageInfo.isNewkey()) {
                    this.saveKey(signerDialog.getSelectedItem(), storageInfo);
                }
            } else {
                responseMessage.setMessage("action.canceled");
            }
        }
        catch (Exception var14) {
            BundleLog.LOG.log(1, var14.getMessage(), var14);
            responseMessage.setMessage(var14.getMessage());
        }
        return this.getJson(responseMessage);
    }

    public String getFilePath(String fileExt, String initialPath) throws Exception {
        FileExtension fileExtension = FileExtension.valueOf(fileExt);
        File[] f = new File[1];
        CountDownLatch readyLatch = new CountDownLatch(1);
        Platform.runLater(() -> {
            f[0] = this.javaFXThread.getFile(initialPath, fileExtension);
            readyLatch.countDown();
        });
        readyLatch.await();
        File file = f[0];
        ResponseForJS<FileInfo> responseForJS = new ResponseForJS<FileInfo>("200");
        try {
            if (file != null) {
                FileInfo fileInfo = new FileInfo(file.getPath(), Files.size(file.toPath()));
                fileInfo.setFilename(file.getName());
                fileInfo.setFiledir(file.getParent());
                responseForJS.setResponseObject(fileInfo);
            } else {
                responseForJS.setResponseObject(new FileInfo());
            }
        }
        catch (IOException var9) {
            BundleLog.LOG.error(var9.getMessage(), var9);
            responseForJS.setCode("500");
            responseForJS.setMessage(this.getMessage("internalError"));
        }
        return this.getJson(responseForJS);
    }

    private void fillFromCert(SignerInfo signerInfo, X509Certificate cert) {
        String[] g;
        String[] cn;
        X509Name x509Name = new X509Name(cert.getSubjectDN().getName());
        HashMap mapRdnOidValue = X509Util.getRDNMapWithArrayValues((X509Name)x509Name);
        String[] valuesArray = (String[])mapRdnOidValue.get(X509Name.SERIALNUMBER.getId());
        if (valuesArray != null && valuesArray.length > 0) {
            signerInfo.setIin(valuesArray[0].substring(3));
        }
        if ((cn = (String[])mapRdnOidValue.get(X509Name.CN.getId())) != null && cn.length > 0) {
            signerInfo.setName(cn[0].trim());
        }
        if ((g = (String[])mapRdnOidValue.get(X509Name.GIVENNAME.getId())) != null && g.length > 0) {
            if (signerInfo.getName() != null) {
                signerInfo.setName(signerInfo.getName() + " " + g[0]);
            } else {
                signerInfo.setName(g[0]);
            }
        }
        try {
            signerInfo.setPersonCertificate(X509Util.containsExtKeyUsage((X509Certificate)cert, (String)"1.2.398.3.3.4.1.1"));
        }
        catch (CertificateParsingException var13) {
            BundleLog.LOG.error(var13.getMessage(), var13);
        }
        if (!signerInfo.isPersonCertificate()) {
            String[] o;
            String[] valuesArray_OU = (String[])mapRdnOidValue.get(X509Name.OU.getId());
            if (valuesArray_OU != null) {
                o = valuesArray_OU;
                int var10 = valuesArray_OU.length;
                for (int var11 = 0; var11 < var10; ++var11) {
                    String value = o[var11];
                    if (!value.contains("BIN") && !value.contains("bin") || value.length() != 15) continue;
                    signerInfo.setBin(value.substring(3));
                }
            }
            if ((o = (String[])mapRdnOidValue.get(X509Name.O.getId())) != null && o.length > 0) {
                signerInfo.setOrganizationName(o[0]);
            }
        }
        signerInfo.setSerialNumber(cert.getSerialNumber().toString(16));
        signerInfo.setCertificateValidityPeriod(this.df.format(cert.getNotBefore()) + " - " + this.df.format(cert.getNotAfter()));
    }

    private List<SignerInfo> verifyCMSResult(byte[] bytes) throws ClientException {
        ArrayList<SignerInfo> signerInfos = new ArrayList<SignerInfo>();
        CMSSignedData cms = null;
        try {
            cms = CMSUtil.parseAsCMS((byte[])bytes);
        }
        catch (CMSException var24) {
            BundleLog.LOG.error(var24.getMessage(), var24);
            throw new ClientException(this.getMessage("cms.exception"));
        }
        CertStore certs = null;
        try {
            certs = cms.getCertificatesAndCRLs("Collection", BundleProvider.KALKAN.getProvider().getName());
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | CMSException var23) {
            BundleLog.LOG.error(var23.getMessage(), var23);
            throw new ClientException(this.getMessage("cms.process.exception"));
        }
        Iterator it = cms.getSignerInfos().getSigners().iterator();
        while (it.hasNext()) {
            SignerInfo signerInfo = new SignerInfo();
            SignerInformation signer = (SignerInformation)it.next();
            Collection<? extends Certificate> certCollection = null;
            try {
                certCollection = certs.getCertificates((CertSelector)signer.getSID());
            }
            catch (CertStoreException var22) {
                BundleLog.LOG.error(var22.getMessage(), var22);
                throw new ClientException(this.getMessage("cms.process.exception"));
            }
            Iterator<? extends Certificate> certIt = certCollection.iterator();
            if (certIt.hasNext()) {
                VerificationResult certVR;
                X509Certificate cert;
                block25: {
                    cert = (X509Certificate)certIt.next();
                    this.fillFromCert(signerInfo, cert);
                    Date sign_date = null;
                    TimeStampToken tsToken = null;
                    try {
                        tsToken = CMSUtil.getTimestampToken((SignerInformation)signer, (Provider)BundleProvider.KALKAN.getProvider());
                    }
                    catch (Exception var21) {
                        BundleLog.LOG.error(var21.getMessage(), var21);
                        throw new ClientException(this.getMessage("cms.process.exception"));
                    }
                    if (tsToken != null) {
                        try {
                            sign_date = tsToken.getTimeStampInfo().getGenTime();
                            signerInfo.setTspDate(this.df.format(sign_date));
                            TSPUtil.validateTimeStampToken((TimeStampToken)tsToken, (byte[])signer.getSignature(), (Provider)BundleProvider.KALKAN.getProvider());
                            signerInfo.setTspVerificationResult(new VerificationResult(true));
                        }
                        catch (IOException | NoSuchAlgorithmException | NoSuchProviderException | CertStoreException | CMSException var19) {
                            BundleLog.LOG.error(var19.getMessage(), var19);
                            throw new ClientException(this.getMessage("cms.process.exception"));
                        }
                        catch (CertificateExpiredException | CertificateNotYetValidException | TSPException | ProviderUtilException var20) {
                            BundleLog.LOG.error(var20.getMessage(), var20);
                            signerInfo.setTspVerificationResult(new VerificationResult(false, this.getMessage("tsp.verification.error")));
                        }
                    } else {
                        signerInfo.setTspVerificationResult(new VerificationResult(false, this.getMessage("tsp.notFound")));
                    }
                    certVR = this.verifyCert(cert, false, sign_date);
                    Date date = sign_date = sign_date == null ? new Date() : sign_date;
                    if (certVR.isValid()) {
                        try {
                            KNCAOCSPChecker checker = new KNCAOCSPChecker(this.getCaCertsMap());
                            checker.check((Certificate)cert);
                        }
                        catch (CertPathValidatorException var25) {
                            Date revokeDate;
                            if (!(var25.getCause() instanceof KalkanException)) break block25;
                            KalkanException ke = (KalkanException)var25.getCause();
                            if (ke.getErrorCode().equals(OCSPCode.STATUS_REVOKED) && (revokeDate = (Date)ke.get("time")).before(sign_date)) {
                                certVR = new VerificationResult(false, this.getMessage("ocsp.revoked"));
                            }
                            if (ke.getErrorCode().equals(OCSPCode.STATUS_UNKNOWN)) {
                                certVR = new VerificationResult(false, this.getMessage("error.certificate.ocsp.unknown"));
                            }
                            if (ke.getErrorCode().equals(OCSPCode.NONCES_NOT_EQUAL)) {
                                certVR = new VerificationResult(false, this.getMessage("error.certificate.ocsp.nonces"));
                            }
                            if (!ke.getErrorCode().equals(OCSPCode.OCSP_RESP_NOT_VERIFIED)) break block25;
                            certVR = new VerificationResult(false, this.getMessage("error.certificate.ocsp.not_verified"));
                        }
                    }
                }
                signerInfo.setCertificateVerificationResult(certVR);
                try {
                    signerInfo.setSignatureVerificationResult(new VerificationResult(signer.verify(cert, BundleProvider.KALKAN.getProvider().getName())));
                }
                catch (CertificateExpiredException | CertificateNotYetValidException var17) {
                    BundleLog.LOG.error(var17.getMessage(), var17);
                    signerInfo.setSignatureVerificationResult(new VerificationResult(false, this.getMessage("sign.validity.cert.invalid")));
                }
                catch (NoSuchAlgorithmException | NoSuchProviderException | CMSException var18) {
                    BundleLog.LOG.error(var18.getMessage(), var18);
                    throw new ClientException(this.getMessage("cms.process.exception"));
                }
            } else {
                signerInfo.setCertificateVerificationResult(new VerificationResult(false, this.getMessage("cms.cert.404")));
            }
            signerInfo.setValidSignature(signerInfo.getSignatureVerificationResult().isValid() && signerInfo.getCertificateVerificationResult().isValid() && signerInfo.getTspVerificationResult().isValid());
            signerInfos.add(signerInfo);
        }
        return signerInfos;
    }

    public String checkCMS(String filePath) {
        ResponseForJS responseForJS = new ResponseForJS("500");
        try {
            FileInfo fileInfo = this.getFileFromPath(filePath);
            List<SignerInfo> listSignerInfo = this.verifyCMSResult(fileInfo.getBytes());
            responseForJS.setCode("200");
            responseForJS.setResponseObjects(listSignerInfo.toArray());
        }
        catch (ClientException var5) {
            responseForJS.setMessage(var5.getMessage());
        }
        catch (Exception var6) {
            BundleLog.LOG.error(var6.getMessage(), var6);
            responseForJS.setMessage(this.getMessage("internalError"));
        }
        return this.getJson(responseForJS);
    }

    private byte[] downloadUrl(URL toDownload) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            int bytesRead;
            byte[] chunk = new byte[4096];
            InputStream stream = toDownload.openStream();
            while ((bytesRead = stream.read(chunk)) > 0) {
                outputStream.write(chunk, 0, bytesRead);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return outputStream.toByteArray();
    }

    public String checkCMSFromWeb(String filePath) {
        ResponseForJS responseForJS = new ResponseForJS("500");
        try {
            byte[] fileInfo = this.downloadUrl(new URL(filePath));
            List<SignerInfo> listSignerInfo = this.verifyCMSResult(fileInfo);
            responseForJS.setCode("200");
            responseForJS.setResponseObjects(listSignerInfo.toArray());
        }
        catch (ClientException var5) {
            responseForJS.setMessage(var5.getMessage());
        }
        catch (Exception var6) {
            BundleLog.LOG.error(var6.getMessage(), var6);
            responseForJS.setMessage(this.getMessage("internalError"));
        }
        return this.getJson(responseForJS);
    }

    public String signXmlApi(final String container, String password, String md5hash) {
        Object result = null;
        ResponseForJS responseForJS = new ResponseForJS("500");
        try {
            String xmlString = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>" + md5hash + "";
            KalkanProvider provider = new KalkanProvider();
            Security.addProvider((Provider)provider);
            KncaXS.loadXMLSecurity();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder documentBuilder = dbf.newDocumentBuilder();
            Document doc = documentBuilder.parse(new ByteArrayInputStream(xmlString.getBytes("UTF-8")));
            KeyStore store = KeyStore.getInstance("PKCS12", provider.getName());
            InputStream inputStream = AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

                @Override
                public FileInputStream run() throws Exception {
                    FileInputStream fis = new FileInputStream(container);
                    return fis;
                }
            });
            store.load(inputStream, password.toCharArray());
            Enumeration<String> als = store.aliases();
            StorageInfo storageInfo = this.getStorageInfoApiWithPathAndPass("PKCS12", container, password);
            KeyStore keyStore = KeyStoreUtil.getKeyStore((Storage)storageInfo.getStorage(), (String)storageInfo.getContainer(), (char[])storageInfo.getPassword(), (Provider)BundleProvider.KALKAN.getProvider());
            Map keyStoreEntries = KeyStoreUtil.getKeyStoreEntries((Storage)storageInfo.getStorage(), (String)storageInfo.getContainer(), (KNCACertificateType)KNCACertificateType.SIGNATURE, (char[])storageInfo.getPassword(), (Provider)BundleProvider.KALKAN.getProvider());
            String alias = null;
            if (keyStoreEntries.size() > 1) {
                alias = this.showKeyChooser(keyStoreEntries.entrySet());
            } else {
                Iterator iterator = keyStoreEntries.keySet().iterator();
                while (iterator.hasNext()) {
                    String key;
                    alias = key = (String)iterator.next();
                }
            }
            SigningEntity signingEntity = KeyStoreUtil.getSigningEntity((KeyStore)keyStore, (String)alias, (char[])storageInfo.getPassword());
            String signed = XMLUtil.createXmlSignature((SigningEntity)signingEntity, (String)xmlString, (String)"", (String)"", (Provider)BundleProvider.KALKAN.getProvider());
            responseForJS.setCode("200");
            responseForJS.setMessage(signed);
        }
        catch (Exception e) {
            e.printStackTrace();
            responseForJS.setMessage(e.getMessage());
        }
        return this.getJson(responseForJS);
    }

    public String signFile(String filePath, String fileUrl, String fileDir, String storageInfoJson) {
        if (filePath != null && !filePath.isEmpty()) {
            return this.signFilePath(filePath, fileDir, storageInfoJson);
        }
        return "no no no !!!";
    }

    public String signFileFromDiskAndSaveToDiskApi(String signToken, String filePath, String fileDir, String keyPath, String keyPassword, String storageInfoJson) {
        ResponseForJS<String> responseForJS = new ResponseForJS<String>("500");
        String tokenResponse = "";
        boolean tokenOk = false;
        try {
            tokenResponse = this.sendGET(signToken);
        }
        catch (Exception ex) {
            System.out.println("tokenResponse error: " + ex.getMessage());
        }
        if (tokenResponse.compareTo("ok") == 0) {
            tokenOk = true;
        } else {
            responseForJS.setMessage(tokenResponse);
        }
        if (tokenOk) {
            try {
                if (storageInfoJson == null || storageInfoJson.trim().isEmpty()) {
                    throw new ClientException(this.getMessage("404"));
                }
                FileInfo fileInfo = this.getFileFromPath(filePath, fileDir);
                responseForJS.setResponseObject(this.signFileFromDiskAndSaveToDisk(fileInfo, storageInfoJson, keyPath, keyPassword));
                responseForJS.setCode("200");
                responseForJS.setMessage(this.getMessage("cms.signed"));
            }
            catch (ClientException e) {
                responseForJS.setMessage(e.getMessage());
            }
            catch (Exception e2) {
                BundleLog.LOG.error(e2.getMessage(), e2);
                responseForJS.setMessage(this.getMessage("internalError"));
            }
        }
        return this.getJson(responseForJS);
    }

    private String signFileFromDiskAndSaveToDisk(FileInfo fileInfo, String storageName, String keyPath, String keyPassword) throws Exception {
        if (storageName == null || storageName.isEmpty()) {
            throw new ClientException(this.getMessage("invalid.param"));
        }
        StorageInfo storageInfo = this.getStorageInfoApiWithPathAndPass(storageName, keyPath, keyPassword);
        Map keyStoreEntries = KeyStoreUtil.getKeyStoreEntries((Storage)storageInfo.getStorage(), (String)storageInfo.getContainer(), (KNCACertificateType)KNCACertificateType.SIGNATURE, (char[])storageInfo.getPassword(), (Provider)BundleProvider.KALKAN.getProvider());
        if (keyStoreEntries.size() > 0) {
            String alias = null;
            if (keyStoreEntries.size() > 1) {
                alias = this.showKeyChooser(keyStoreEntries.entrySet());
            } else {
                Iterator iterator = keyStoreEntries.keySet().iterator();
                while (iterator.hasNext()) {
                    String key;
                    alias = key = (String)iterator.next();
                }
            }
            if (alias != null) {
                this.checkCert(((KeyStoreEntry)keyStoreEntries.get(alias)).getX509Certificate());
                CMSSignedData cmsSignedData = this.createCAdES(storageInfo.getKeyStore(), alias, storageInfo.getPassword(), fileInfo.getBytes());
                return this.saveFile(cmsSignedData, fileInfo.getFilename(), fileInfo.getFiledir());
            }
            throw new ClientException(this.getMessage("action.canceled"));
        }
        throw new ClientException(this.getMessage("keyNotFound"));
    }

    private String sendGET(String signTokenInput) throws IOException {
        String returnValue = "";
        String USER_AGENT = "Mozilla/5.0";
        String signToken = "";
        String url = "";
        if (signTokenInput.contains("test")) {
            url = "http://localhost:8080/checkSignToken";
            signToken = signTokenInput.substring(5);
        } else {
            url = "http://ncalayer.uchet.kz:8080/checkSignToken";
            signToken = signTokenInput;
        }
        URL obj = new URL(url);
        HttpURLConnection con = (HttpURLConnection)obj.openConnection();
        con.setRequestMethod("POST");
        con.setRequestProperty("User-Agent", USER_AGENT);
        con.setRequestProperty("Accept-Language", "en-US,en;q=0.5");
        con.setRequestProperty("Content-Type", "application/json");
        String postJsonData = "{\"sign_token\":\"" + signToken + "\"}";
        try {
            String output;
            con.setDoOutput(true);
            DataOutputStream wr = new DataOutputStream(con.getOutputStream());
            wr.writeBytes(postJsonData);
            wr.flush();
            wr.close();
            int responseCode = con.getResponseCode();
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuffer response = new StringBuffer();
            while ((output = in.readLine()) != null) {
                response.append(output);
            }
            in.close();
            JSONObject jsonObject = new JSONObject(response.toString());
            String error = jsonObject.getString("error");
            String result = jsonObject.getString("result");
            if (error.isEmpty()) {
                returnValue = result;
            }
            if (result.isEmpty()) {
                returnValue = error;
            }
        }
        catch (Exception ex) {
            returnValue = "\u0421\u0435\u0440\u0432\u0435\u0440 \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d";
        }
        return returnValue;
    }

    private StorageInfo getStorageInfoApiWithPathAndPass(String name, String keyPath, String keyPassword) throws ClientException {
        StorageInfo storageInfo = new StorageInfo(name);
        if (storageInfo.getStorage().isToken() && storageInfo.getContainers().size() == 0) {
            throw new ClientException("\u041d\u043e\u0441\u0438\u0442\u0435\u043b\u044c \u043d\u0435 \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d");
        }
        storageInfo.setContainer(keyPath);
        char[] pass = keyPassword.toCharArray();
        storageInfo.setPassword(pass);
        try {
            storageInfo.setKeyStore(this.getKeyStore(storageInfo));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (storageInfo.getKeyStore() == null) {
            throw new ClientException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u0442\u043a\u0440\u044b\u0442\u044c \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435");
        }
        return storageInfo;
    }

    public String signFileAndReturnBase64Api(String signToken, String fileBase64, String keyPath, String keyPassword, String storageInfoJson) {
        ResponseForJS<String> responseForJS = new ResponseForJS<String>("500");
        String tokenResponse = "";
        boolean tokenOk = false;
        try {
            tokenResponse = this.sendGET(signToken);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tokenResponse.compareTo("ok") == 0) {
            tokenOk = true;
        } else {
            responseForJS.setMessage(tokenResponse);
        }
        if (tokenOk) {
            try {
                if (storageInfoJson == null || storageInfoJson.trim().isEmpty()) {
                    throw new ClientException(this.getMessage("404"));
                }
                FileInfo fileInfo = this.getFileFromBase64(fileBase64);
                responseForJS.setResponseObject(this.signFileFromBase64AndReturn(fileInfo, storageInfoJson, keyPath, keyPassword));
                responseForJS.setCode("200");
                responseForJS.setMessage(this.getMessage("cms.signed"));
            }
            catch (ClientException e) {
                responseForJS.setMessage(e.getMessage());
            }
            catch (Exception e2) {
                BundleLog.LOG.error(e2.getMessage(), e2);
                responseForJS.setMessage(this.getMessage("internalError"));
            }
        }
        return this.getJson(responseForJS);
    }

    private String signFileFromBase64AndReturn(FileInfo fileInfo, String storageName, String keyPath, String keyPassword) throws Exception {
        if (storageName == null || storageName.isEmpty()) {
            throw new ClientException(this.getMessage("invalid.param"));
        }
        StorageInfo storageInfo = this.getStorageInfoApiWithPathAndPass(storageName, keyPath, keyPassword);
        Map keyStoreEntries = KeyStoreUtil.getKeyStoreEntries((Storage)storageInfo.getStorage(), (String)storageInfo.getContainer(), (KNCACertificateType)KNCACertificateType.SIGNATURE, (char[])storageInfo.getPassword(), (Provider)BundleProvider.KALKAN.getProvider());
        if (keyStoreEntries.size() > 0) {
            String alias = null;
            if (keyStoreEntries.size() > 1) {
                alias = this.showKeyChooser(keyStoreEntries.entrySet());
            } else {
                Iterator iterator = keyStoreEntries.keySet().iterator();
                while (iterator.hasNext()) {
                    String key;
                    alias = key = (String)iterator.next();
                }
            }
            if (alias != null) {
                this.checkCert(((KeyStoreEntry)keyStoreEntries.get(alias)).getX509Certificate());
                CMSSignedData cmsSignedData = this.createCAdES(storageInfo.getKeyStore(), alias, storageInfo.getPassword(), fileInfo.getBytes());
                return new String(Base64.getEncoder().encode(cmsSignedData.getEncoded()));
            }
            throw new ClientException(this.getMessage("action.canceled"));
        }
        throw new ClientException(this.getMessage("keyNotFound"));
    }

    private FileInfo getFileFromBase64(String base64String) {
        FileInfo newFile = new FileInfo();
        try {
            byte[] name = Base64.getEncoder().encode(base64String.getBytes());
            byte[] decodedImg = Base64.getDecoder().decode(base64String.getBytes(StandardCharsets.UTF_8));
            newFile.setBytes(decodedImg);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return newFile;
    }

    private String signApi(FileInfo fileInfo, String storageName) throws Exception {
        if (storageName == null || storageName.isEmpty()) {
            throw new ClientException(this.getMessage("invalid.param"));
        }
        StorageInfo storageInfo = this.getStorageInfoApi(storageName);
        Map keyStoreEntries = KeyStoreUtil.getKeyStoreEntries((Storage)storageInfo.getStorage(), (String)storageInfo.getContainer(), (KNCACertificateType)KNCACertificateType.SIGNATURE, (char[])storageInfo.getPassword(), (Provider)BundleProvider.KALKAN.getProvider());
        if (keyStoreEntries.size() > 0) {
            String alias = null;
            if (keyStoreEntries.size() > 1) {
                alias = this.showKeyChooser(keyStoreEntries.entrySet());
            } else {
                Iterator iterator = keyStoreEntries.keySet().iterator();
                while (iterator.hasNext()) {
                    String key;
                    alias = key = (String)iterator.next();
                }
            }
            if (alias != null) {
                this.checkCert(((KeyStoreEntry)keyStoreEntries.get(alias)).getX509Certificate());
                CMSSignedData cmsSignedData = this.createCAdES(storageInfo.getKeyStore(), alias, storageInfo.getPassword(), fileInfo.getBytes());
                return this.saveFile(cmsSignedData, fileInfo.getFilename(), fileInfo.getFiledir());
            }
            throw new ClientException(this.getMessage("action.canceled"));
        }
        throw new ClientException(this.getMessage("keyNotFound"));
    }

    private StorageInfo getStorageInfoApi(String name) throws ClientException {
        StorageInfo storageInfo = new StorageInfo(name);
        if (storageInfo.getStorage().isToken() && storageInfo.getContainers().size() == 0) {
            throw new ClientException("\u041d\u043e\u0441\u0438\u0442\u0435\u043b\u044c \u043d\u0435 \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d");
        }
        storageInfo.setContainer("/Users/leonid/Documents/\u041a\u043b\u044e\u0447\u0438 \u0435\u0433\u043e\u0432/\u041c\u043e\u0438 2020/RSA256_58e56100313971b5b938a443b8be3f78879d60fd.p12");
        char[] pass = "F1rstB1t".toCharArray();
        storageInfo.setPassword(pass);
        try {
            storageInfo.setKeyStore(this.getKeyStore(storageInfo));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (storageInfo.getKeyStore() == null) {
            throw new ClientException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u0442\u043a\u0440\u044b\u0442\u044c \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435");
        }
        return storageInfo;
    }

    private KeyStore getKeyStore(StorageInfo storageInfo) throws Exception {
        try {
            return KeyStoreUtil.getKeyStore((Storage)storageInfo.getStorage(), (String)storageInfo.getContainer(), (char[])storageInfo.getPassword(), (Provider)BundleProvider.KALKAN.getProvider());
        }
        catch (ProviderUtilException e) {
            BundleLog.LOG.log(1, e.getMessage(), e);
            if (e.getCode().equals((Object)ProviderUtilExceptionCode.WRONG_KEYSTORE_PASSWORD)) {
                String msg = this.getMessage("pwd.wrongPin");
                if (e.getTryCount() > -1) {
                    msg = msg + " " + this.getMessage("pwd.retryCount") + " " + String.valueOf(e.getTryCount());
                }
                throw new ClientException(msg);
            }
            if (e.getCode().equals((Object)ProviderUtilExceptionCode.BLOCKED_KEYSTORE_PASSWORD)) {
                throw new ClientException(this.getMessage("pwd.blocked"));
            }
            throw new ClientException(e.getMessage());
        }
    }

    public String signFilePath(String filePath, String fileDir, String storageInfoJson) {
        ResponseForJS<String> responseForJS = new ResponseForJS<String>("500");
        try {
            if (storageInfoJson == null || storageInfoJson.trim().isEmpty()) {
                throw new ClientException(this.getMessage("404"));
            }
            FileInfo fileInfo = this.getFileFromPath(filePath, fileDir);
            responseForJS.setResponseObject(this.sign(fileInfo, storageInfoJson));
            responseForJS.setCode("200");
            responseForJS.setMessage(this.getMessage("cms.signed"));
        }
        catch (ClientException e) {
            responseForJS.setMessage(e.getMessage());
        }
        catch (Exception e2) {
            BundleLog.LOG.error(e2.getMessage(), e2);
            responseForJS.setMessage(this.getMessage("internalError"));
        }
        return this.getJson(responseForJS);
    }

    private String sign(FileInfo fileInfo, String storageName) throws Exception {
        if (storageName == null || storageName.isEmpty()) {
            throw new ClientException(this.getMessage("invalid.param"));
        }
        StorageInfo storageInfo = this.getStorageInfo(storageName);
        Map keyStoreEntries = KeyStoreUtil.getKeyStoreEntries((Storage)storageInfo.getStorage(), (String)storageInfo.getContainer(), (KNCACertificateType)KNCACertificateType.SIGNATURE, (char[])storageInfo.getPassword(), (Provider)BundleProvider.KALKAN.getProvider());
        if (keyStoreEntries.size() > 0) {
            String alias = null;
            if (keyStoreEntries.size() > 1) {
                alias = this.showKeyChooser(keyStoreEntries.entrySet());
            } else {
                Iterator iterator = keyStoreEntries.keySet().iterator();
                while (iterator.hasNext()) {
                    String key;
                    alias = key = (String)iterator.next();
                }
            }
            if (alias != null) {
                this.checkCert(((KeyStoreEntry)keyStoreEntries.get(alias)).getX509Certificate());
                CMSSignedData cmsSignedData = this.createCAdES(storageInfo.getKeyStore(), alias, storageInfo.getPassword(), fileInfo.getBytes());
                return this.saveFile(cmsSignedData, fileInfo.getFilename(), fileInfo.getFiledir());
            }
            throw new ClientException(this.getMessage("action.canceled"));
        }
        throw new ClientException(this.getMessage("keyNotFound"));
    }

    private CMSSignedData createCAdES(KeyStore keyStore, String alias, char[] passwrd, byte[] fileBytes) throws Exception {
        try {
            SigningEntity signingEntity = KeyStoreUtil.getSigningEntity((KeyStore)keyStore, (String)alias, (char[])passwrd);
            CMSSignedData cmsSignedData = CMSUtil.createCAdES((SigningEntity)signingEntity, (byte[])fileBytes, (boolean)true, (Provider)BundleProvider.KALKAN.getProvider());
            TSAProfile tsaProfile = new TSAProfile();
            tsaProfile.setHashAlgorithm(KalkanHashAlgorithm.HASH_SHA256);
            tsaProfile.setRequestMethod(KNCAServiceRequestMethod.GET);
            tsaProfile.setTsaPolicy(TSAPolicy.TSA_RSA);
            cmsSignedData = CMSUtil.applyCAdEST((CMSSignedData)cmsSignedData, (SigningEntity)signingEntity, (TSAProfile)tsaProfile, (Provider)BundleProvider.KALKAN.getProvider());
            return cmsSignedData;
        }
        catch (ProviderUtilException e) {
            BundleLog.LOG.error(e.getMessage(), e);
            throw new ClientException("\u041e\u0448\u0438\u0431\u043a\u0430. \u041a\u043e\u0434: " + e.getCode().name());
        }
    }

    private String saveFile(CMSSignedData cmsSignedData, String fileName, String fileDir) throws ClientException {
        try {
            Path signedFile = null;
            try {
                signedFile = Paths.get(fileDir + FileSystems.getDefault().getSeparator() + fileName + (fileName.endsWith(".cms") ? "" : ".cms"), new String[0]);
            }
            catch (InvalidPathException e) {
                BundleLog.LOG.error(e.getMessage(), e);
                signedFile = Paths.get(fileDir + FileSystems.getDefault().getSeparator() + "signedCMS.cms", new String[0]);
            }
            Files.write(signedFile, cmsSignedData.getEncoded(), new OpenOption[0]);
            return signedFile.toAbsolutePath().toString();
        }
        catch (Exception e2) {
            BundleLog.LOG.error(e2.getMessage(), e2);
            throw new ClientException(this.getMessage("file.ioException"));
        }
    }

    private void checkCert(X509Certificate cert) throws ClientException {
        VerificationResult certVR;
        block7: {
            certVR = this.verifyCert(cert, false, null);
            if (certVR.isValid()) {
                try {
                    KNCAOCSPChecker checker = new KNCAOCSPChecker(this.getCaCertsMap());
                    checker.check((Certificate)cert);
                }
                catch (CertPathValidatorException e) {
                    if (!(e.getCause() instanceof KalkanException)) break block7;
                    KalkanException ke = (KalkanException)e.getCause();
                    if (ke.getErrorCode().equals(OCSPCode.STATUS_REVOKED)) {
                        certVR = new VerificationResult(false, this.getMessage("ocsp.revoked"));
                    }
                    if (ke.getErrorCode().equals(OCSPCode.STATUS_UNKNOWN)) {
                        certVR = new VerificationResult(false, this.getMessage("error.certificate.ocsp.unknown"));
                    }
                    if (ke.getErrorCode().equals(OCSPCode.NONCES_NOT_EQUAL)) {
                        certVR = new VerificationResult(false, this.getMessage("error.certificate.ocsp.nonces"));
                    }
                    if (!ke.getErrorCode().equals(OCSPCode.OCSP_RESP_NOT_VERIFIED)) break block7;
                    certVR = new VerificationResult(false, this.getMessage("error.certificate.ocsp.not_verified"));
                }
            }
        }
        if (!certVR.isValid()) {
            throw new ClientException(certVR.getMessage());
        }
    }

    private Map<X500Principal, X509Certificate> getCaCertsMap() {
        this.caCertsMap = new HashMap<X500Principal, X509Certificate>();
        for (X509Certificate X509cert : this.getCaCertList()) {
            this.caCertsMap.put(X509cert.getSubjectX500Principal(), X509cert);
        }
        return this.caCertsMap;
    }

    private VerificationResult verifyCert(X509Certificate cert, boolean ocsp, Date checkDate) throws ClientException {
        try {
            if (!X509Util.getKNCACertificateType((X509Certificate)cert).contains(KNCACertificateType.SIGNATURE)) {
                return new VerificationResult(false, this.getMessage("error.certificate.type"));
            }
            try {
                PKIXUtil pkixUtil = new PKIXUtil(cert, this.getCaCertList());
                if (ocsp) {
                    pkixUtil = pkixUtil.withOCSP();
                }
                if (checkDate != null) {
                    pkixUtil.withDate(checkDate);
                }
                pkixUtil.validate();
            }
            catch (ProviderUtilException pue) {
                CertPathBuilderException e;
                BundleLog.LOG.error(pue.getMessage(), pue);
                if (pue.getCause() != null && pue.getCause() instanceof CertPathBuilderException && (e = (CertPathBuilderException)pue.getCause()).getCause() != null && e.getCause() instanceof ExtCertPathValidatorException) {
                    CertPathValidatorException eee;
                    ExtCertPathValidatorException ee = (ExtCertPathValidatorException)e.getCause();
                    if (ee.getCause() != null && ee.getCause() instanceof CertificateExpiredException) {
                        return new VerificationResult(false, this.getMessage("cert.expired"));
                    }
                    if (ee.getCause() != null && ee.getCause() instanceof CertificateNotYetValidException) {
                        return new VerificationResult(false, this.getMessage("cert.not_yet_valid"));
                    }
                    if (ee.getCause() != null && ee.getCause() instanceof CertPathValidatorException && (eee = (CertPathValidatorException)ee.getCause()).getCause() != null && eee.getCause() instanceof KalkanException) {
                        KalkanException ke = (KalkanException)eee.getCause();
                        if (ke.getErrorCode().equals(OCSPCode.STATUS_REVOKED)) {
                            return new VerificationResult(false, this.getMessage("ocsp.revoked"));
                        }
                        if (ke.getErrorCode().equals(OCSPCode.STATUS_UNKNOWN)) {
                            return new VerificationResult(false, this.getMessage("error.certificate.ocsp.unknown"));
                        }
                        if (ke.getErrorCode().equals(OCSPCode.NONCES_NOT_EQUAL)) {
                            return new VerificationResult(false, this.getMessage("error.certificate.ocsp.nonces"));
                        }
                        if (ke.getErrorCode().equals(OCSPCode.OCSP_RESP_NOT_VERIFIED)) {
                            return new VerificationResult(false, this.getMessage("error.certificate.ocsp.not_verified"));
                        }
                        if (ke.getErrorCode().equals(OCSPCode.THIS_UPDATE_NOT_SATISFIED) || ke.getErrorCode().equals(OCSPCode.NEXT_UPDATE_NOT_SATISFIED) || ke.getErrorCode().equals(OCSPCode.ALLOWED_PERIOD_NOT_SATISFIED)) {
                            return new VerificationResult(false, this.getMessage("ocsp.exception"));
                        }
                    }
                    if (ee.getCause() != null && ee.getCause() instanceof InvalidKeyException) {
                        return new VerificationResult(false, this.getMessage("error.certificate.ca"));
                    }
                }
                if (pue.getCode().equals((Object)ProviderUtilExceptionCode.ISSUER_CERT_NOT_FOUND)) {
                    return new VerificationResult(false, this.getMessage("error.certificate.ca"));
                }
                return new VerificationResult(false, pue.getCode().toString());
            }
            if (X509Util.containsExtKeyUsage((X509Certificate)cert, (String)"1.2.398.5.19.1.2.2.1.2") || X509Util.containsExtKeyUsage((X509Certificate)cert, (String)"1.2.398.5.19.1.2.2.1")) {
                return new VerificationResult(false, this.getMessage("cert.verification.error"));
            }
            return new VerificationResult(true);
        }
        catch (Exception e) {
            BundleLog.LOG.error(e.getMessage(), e);
            throw new ClientException(this.getMessage("cert.process.exception"));
        }
    }

    private static X509Certificate generateCert(InputStream certFile) throws Exception {
        return (X509Certificate)CertificateFactory.getInstance("X.509", "KALKAN").generateCertificate(certFile);
    }

    private Collection<X509Certificate> getCaCertList() {
        X509Certificate cert;
        InputStream in1;
        this.caCertList = new ArrayList<X509Certificate>();
        try {
            in1 = new URL("https://pki.gov.kz/cert/nca_gost.crt").openStream();
            cert = CommonUtils.generateCert(in1);
            if (cert != null) {
                try {
                    this.caCertList.add(cert);
                }
                catch (Exception eex) {
                    System.out.println("error addind new cert " + eex.getMessage());
                }
            } else {
                System.out.println("cert is null");
            }
        }
        catch (Exception ex) {
            System.out.println("errr " + ex.getMessage());
        }
        try {
            in1 = new URL("https://pki.gov.kz/cert/nca_rsa.crt").openStream();
            cert = CommonUtils.generateCert(in1);
            if (cert != null) {
                try {
                    this.caCertList.add(cert);
                }
                catch (Exception eex) {
                    System.out.println("error addind new cert " + eex.getMessage());
                }
            } else {
                System.out.println("cert is null");
            }
        }
        catch (Exception ex) {
            System.out.println("errr " + ex.getMessage());
        }
        return this.caCertList;
    }

    public String showKeyChooser(Collection<Map.Entry<String, KeyStoreEntry>> list) {
        String[] result = new String[]{null};
        return "";
    }

    private StorageInfo getStorageInfo(String name) throws ClientException {
        StorageInfo storageInfo = new StorageInfo(name);
        if (storageInfo.getStorage().isToken() && storageInfo.getContainers().size() == 0) {
            throw new ClientException("\u041d\u043e\u0441\u0438\u0442\u0435\u043b\u044c \u043d\u0435 \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d");
        }
        CountDownLatch readyLatch = new CountDownLatch(1);
        Platform.runLater(() -> {
            this.javaFXThread.fillStorageInfo(storageInfo);
            readyLatch.countDown();
        });
        try {
            readyLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (storageInfo.getKeyStore() == null) {
            throw new ClientException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u0442\u043a\u0440\u044b\u0442\u044c \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435");
        }
        return storageInfo;
    }

    public String getMessage(String key) {
        return ResourceBundle.getBundle("i18n.dictionary", this.locale).getString(key);
    }

    private FileInfo getFileFromPath(String filePath, String fileDir) throws ClientException {
        if (fileDir == null || fileDir.trim().isEmpty()) {
            throw new ClientException(this.getMessage("404"));
        }
        FileInfo fileInfo = this.getFileFromPath(filePath);
        fileInfo.setFiledir(fileDir);
        return fileInfo;
    }

    private FileInfo getFileFromPath(String filePath) throws ClientException {
        if (filePath == null || filePath.trim().isEmpty()) {
            throw new ClientException(this.getMessage("404"));
        }
        FileInfo fileInfo = new FileInfo();
        try {
            Path forSign = Paths.get(filePath, new String[0]);
            fileInfo.setBytes(this.getBytes(forSign));
            fileInfo.setFilename(forSign.getFileName().toString());
            if (fileInfo.getBytes() == null) {
                throw new ClientException(this.getMessage("file.ioException"));
            }
        }
        catch (IOException e) {
            BundleLog.LOG.error(e.getMessage(), e);
            throw new ClientException(this.getMessage("file.ioException"));
        }
        return fileInfo;
    }

    private byte[] getBytes(Path path) throws IOException {
        try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
            byte[] byArray = Files.readAllBytes(path);
            return byArray;
        }
    }

    private void saveKey(KeyStoreEntry keyStoreEntry, StorageInfo storageInfo) {
    }

    private String getJson(Object o) {
        return ((JSONObject)JSONObject.wrap((Object)o)).toString();
    }
}

