/*
 * Decompiled with CFR 0.152.
 */
package kz.uchet.signUtil;

import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.function.Function;
import kz.gov.pki.osgi.layer.api.ModuleService;
import kz.uchet.signUtil.BundleLog;
import kz.uchet.signUtil.BundleProvider;
import kz.uchet.signUtil.CommonUtils;
import kz.uchet.signUtil.types.ResponseMessage;
import org.json.JSONArray;
import org.json.JSONObject;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class NCALayerCommonActivator
implements BundleActivator {
    private static final int[] ARRAY_INT = new int[0];
    private static final String[] ARRAY_STRING = new String[0];

    public void start(BundleContext context) throws Exception {
        try {
            BundleLog.LOG.discoverLogService();
            BundleProvider.KALKAN.discoverProviderService();
            CommonUtils commonUtils = new CommonUtils();
            this.getKeyInfoService(context, commonUtils);
            this.getKeyInfoSetterService(context, commonUtils);
            Hashtable<String, String> props = new Hashtable<String, String>();
            props.put("module", "kz.uchet.signUtil.commonUtils");
            context.registerService(ModuleService.class.getName().toString(), (Object)this.getModuleService(commonUtils), props);
        }
        catch (Exception var4) {
            BundleLog.LOG.log(1, var4.getMessage(), var4);
            throw new Exception("Can not start bundle NCALayerCommon!");
        }
    }

    private void getKeyInfoService(BundleContext context, CommonUtils commonUtils) throws Exception {
        String serviceFilter = "(&(objectClass=" + Function.class.getName() + ")(module=kz.gov.pki.ncalayerservices.getKeyInfo))";
        ServiceTracker module_tracker = new ServiceTracker(context, context.createFilter(serviceFilter), (ServiceTrackerCustomizer)null);
        module_tracker.open();
        Function ncalayerservices_accessory = (Function)module_tracker.getService();
        if (ncalayerservices_accessory == null) {
            context.addServiceListener(e -> {
                if (e.getType() == 1) {
                    commonUtils.setKeyInfoServices((Function)module_tracker.getService(e.getServiceReference()));
                }
            }, serviceFilter);
        } else {
            commonUtils.setKeyInfoServices(ncalayerservices_accessory);
        }
    }

    private void getKeyInfoSetterService(BundleContext context, CommonUtils commonUtils) throws Exception {
        String serviceFilter = "(&(objectClass=" + Function.class.getName() + ")(module=kz.gov.pki.ncalayerservices.setKeyInfo))";
        ServiceTracker module_tracker = new ServiceTracker(context, context.createFilter(serviceFilter), (ServiceTrackerCustomizer)null);
        module_tracker.open();
        Function ncalayerservices_accessory = (Function)module_tracker.getService();
        if (ncalayerservices_accessory == null) {
            context.addServiceListener(e -> {
                if (e.getType() == 1) {
                    commonUtils.setKeyInfoSetterService((Function)module_tracker.getService(e.getServiceReference()));
                }
            }, serviceFilter);
        } else {
            commonUtils.setKeyInfoSetterService(ncalayerservices_accessory);
        }
    }

    public void stop(BundleContext context) throws Exception {
    }

    private ModuleService getModuleService(CommonUtils commonUtils) {
        return (jsonString, headers) -> {
            try {
                String jsonResult;
                Method[] var11;
                JSONObject jsonObject = new JSONObject(jsonString);
                String uuid = jsonObject.optString("uuid");
                String mname = jsonObject.getString("method");
                JSONArray args = jsonObject.optJSONArray("args");
                int argLen = args != null ? args.length() : 0;
                Method method = null;
                if (!mname.isEmpty()) {
                    Method[] ms;
                    var11 = ms = commonUtils.getClass().getDeclaredMethods();
                    int var12 = ms.length;
                    for (int var13 = 0; var13 < var12; ++var13) {
                        Method m = var11[var13];
                        if (!m.getName().equals(mname) || m.getParameterTypes().length != argLen) continue;
                        method = m;
                        break;
                    }
                }
                if (method == null) {
                    return this.getErrorResponse("NoSuchMethodException " + mname);
                }
                Object[] argObjs = null;
                if (argLen > 0) {
                    argObjs = new Object[argLen];
                }
                for (int i = 0; i < argLen; ++i) {
                    int j;
                    Object objArg = args.get(i);
                    if (!(objArg instanceof JSONArray)) {
                        argObjs[i] = objArg;
                        continue;
                    }
                    JSONArray arrayObj = (JSONArray)objArg;
                    if (method.getParameterTypes()[i].isInstance(ARRAY_INT)) {
                        int[] arrayArgxx = new int[arrayObj.length()];
                        for (j = 0; j < arrayArgxx.length; ++j) {
                            arrayArgxx[j] = arrayObj.getInt(j);
                        }
                        argObjs[i] = arrayArgxx;
                        continue;
                    }
                    if (method.getParameterTypes()[i].isInstance(ARRAY_STRING)) {
                        String[] arrayArgx = new String[arrayObj.length()];
                        for (j = 0; j < arrayArgx.length; ++j) {
                            arrayArgx[j] = arrayObj.getString(j);
                        }
                        argObjs[i] = arrayArgx;
                        continue;
                    }
                    Object[] arrayArg = new Object[arrayObj.length()];
                    for (j = 0; j < arrayArg.length; ++j) {
                        arrayArg[j] = arrayObj.get(j);
                    }
                    argObjs[i] = arrayArg;
                }
                var11 = null;
                try {
                    jsonResult = (String)method.invoke((Object)commonUtils, argObjs);
                }
                catch (Exception var16) {
                    BundleLog.LOG.log(1, var16.getMessage(), var16);
                    return this.getErrorResponse(var16 + ". Method: " + mname);
                }
                if (uuid.isEmpty()) {
                    return jsonResult;
                }
                JSONObject resultObject = new JSONObject(jsonResult);
                return resultObject.put("uuid", (Object)uuid).toString();
            }
            catch (Exception var17) {
                BundleLog.LOG.log(1, var17.getMessage(), var17);
                return this.getErrorResponse(var17.getMessage());
            }
        };
    }

    private String getErrorResponse(String msg) {
        ResponseMessage responseForJS = new ResponseMessage("500");
        responseForJS.setMessage(msg);
        return ((JSONObject)JSONObject.wrap(responseForJS)).toString();
    }
}

