/*
 * Decompiled with CFR 0.152.
 */
package kz.uchet.signUtil.gui.dialog;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.security.KeyStore;
import java.security.Provider;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import kz.gov.pki.kalkan.Storage;
import kz.gov.pki.provider.exception.ProviderUtilException;
import kz.gov.pki.provider.exception.ProviderUtilExceptionCode;
import kz.gov.pki.provider.utils.KeyStoreUtil;
import kz.gov.pki.reference.KNCACertificateType;
import kz.gov.pki.reference.KeyStoreEntry;
import kz.uchet.signUtil.BundleLog;
import kz.uchet.signUtil.BundleProvider;
import kz.uchet.signUtil.gui.GUiConstants;
import kz.uchet.signUtil.gui.ProgramSettings;
import kz.uchet.signUtil.types.ClientException;
import kz.uchet.signUtil.types.StorageInfo;

public class SignerDialog
extends JDialog {
    protected JPanel contentPanel;
    private JPanel keyInfoPanel;
    private JPanel keyListPanel;
    private JLabel mesLabel;
    private JButton showPwdBtn;
    private KeyListEntry selectedItem;
    private StorageInfo storageInfo;
    private KNCACertificateType keyType;
    private JButton refreshKeyListButton;
    private JButton canButton;
    private JButton signButton;
    private JButton cancelButton;
    private JComboBox containerComboBox;
    private JPasswordField passwordField;
    private JLabel refreshLoadingJLabel;
    private JLabel signLoadingJLabel;
    private JComboBox keyListComboBox;
    private ImageIcon loadingImage;
    private JLabel keyOwnerText;
    private JLabel periodText;
    private JLabel serialNumberText;
    private JLabel issuerNameText;
    private JLabel algNameText;
    private boolean doSign;
    private Map<String, String> titles;
    private final int windowWidth = 660;
    private final int borderGap = 15;
    private final int eleGap = 5;
    private final int mesPanelH = 60;
    private final int headerH = 60;

    public SignerDialog(StorageInfo sInfo, KNCACertificateType inKeyType, Map<String, String> titles) {
        this.storageInfo = sInfo;
        this.titles = titles;
        this.keyType = inKeyType;
        this.getContentPane().setLayout(new BorderLayout());
        this.initHeader();
        this.fillContentPane();
        this.initFooter();
        this.setDialogProperties();
    }

    private void initHeader() {
        String titleKey = this.titles.containsKey("header") ? this.titles.get("header") : (this.keyType != null && this.keyType.equals((Object)KNCACertificateType.AUTHENTICATION) ? "label.signerDialog.authTitle" : "label.signerDialog.signTitle");
        JPanel header = new JPanel();
        header.setPreferredSize(new Dimension(660, 60));
        header.setLayout(new FlowLayout(1, 5, 5));
        this.getContentPane().add((Component)header, "North");
        JLabel titleLabel = new JLabel("<html><p>" + ProgramSettings.getInstance().getDictionary(titleKey) + "</p></html>");
        titleLabel.setPreferredSize(new Dimension(630, 45));
        titleLabel.setForeground(Color.BLACK);
        titleLabel.setFont(new Font("Tahoma", 1, 14));
        header.add(titleLabel);
    }

    private void fillContentPane() {
        this.contentPanel = new JPanel();
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setPreferredSize(new Dimension(660, 144));
        this.contentPanel.setLayout(null);
        this.contentPanel.add(this.getRefreshLoadingJLabel());
        this.initKeyListPanel();
        this.addStorageTypeForm();
        this.addContainerTypeForm();
        JLabel warningText = this.getWarningText();
        this.contentPanel.add(warningText);
        KeyListener capsLockListener = this.getCapsLockListener(warningText);
        this.addPasswordForm(capsLockListener);
        this.contentPanel.add(this.getShowPwdBtn(capsLockListener));
        this.addRefreshBtn(capsLockListener);
        this.addCancelBtn(capsLockListener);
    }

    private void addRefreshBtn(KeyListener capsLockListener) {
        this.refreshKeyListButton = this.addButton("button.signerDialog.refreshKeyList", GUiConstants.BUTTON_BACKGROUND_COLOR, new Rectangle(226, 100, 207, 35), this.contentPanel);
        this.refreshKeyListButton.addActionListener(a -> {
            if (this.passwordField.getPassword() != null && this.passwordField.getPassword().length != 0) {
                this.blockRefreshPart();
                ExecutorService executorService = Executors.newSingleThreadExecutor();
                executorService.execute(() -> {
                    try {
                        this.storageInfo.setPassword(this.passwordField.getPassword());
                        List<KeyListEntry> keys = this.refreshKeyList();
                        if (keys == null || keys.isEmpty()) {
                            if (this.keyType != null && this.keyType.equals((Object)KNCACertificateType.AUTHENTICATION)) {
                                this.setMessage(ProgramSettings.getInstance().getDictionary("label.errorMessage.emptyStorage.auth"));
                            } else if (this.keyType != null && this.keyType.equals((Object)KNCACertificateType.SIGNATURE)) {
                                this.setMessage(ProgramSettings.getInstance().getDictionary("label.errorMessage.emptyStorage.sign"));
                            } else {
                                this.setMessage(ProgramSettings.getInstance().getDictionary("label.errorMessage.emptyStorage"));
                            }
                            this.keyListPanel.setVisible(false);
                            this.contentPanel.setPreferredSize(new Dimension(this.contentPanel.getPreferredSize().width, 144));
                            this.unblockRefreshPart();
                            this.pack();
                        } else {
                            this.contentPanel.setPreferredSize(new Dimension(this.contentPanel.getPreferredSize().width, 401));
                            this.updateKeyList(keys);
                            this.pack();
                            this.refreshLoadingJLabel.setVisible(false);
                            this.keyListPanel.setVisible(true);
                            this.getRootPane().setDefaultButton(this.signButton);
                        }
                    }
                    catch (Exception e) {
                        BundleLog.LOG.log(1, e.getMessage(), e);
                        this.unblockRefreshPart();
                        this.setMessage(e.getMessage());
                    }
                });
                executorService.shutdown();
            } else {
                this.setMessage(ProgramSettings.getInstance().getDictionary("label.errorMessage.emptyField"));
            }
        });
        this.refreshKeyListButton.addKeyListener(capsLockListener);
        this.getRootPane().setDefaultButton(this.refreshKeyListButton);
    }

    private void addCancelBtn(KeyListener capsLockListener) {
        this.canButton = this.addButton("button.cancel", GUiConstants.BUTTON_BACKGROUND_COLOR, new Rectangle(438, 100, 207, 35), this.contentPanel);
        this.canButton.addActionListener(a -> {
            this.setVisible(false);
            this.dispose();
        });
        this.canButton.addKeyListener(capsLockListener);
    }

    private JButton getShowPwdBtn(KeyListener capsLockListener) {
        this.showPwdBtn = new JButton(new ImageIcon(SignerDialog.class.getClassLoader().getResource("eye_16.png")));
        this.showPwdBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SignerDialog.this.showPwdBtn.isEnabled()) {
                    SignerDialog.this.passwordField.setEchoChar('\u0000');
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SignerDialog.this.showPwdBtn.isEnabled()) {
                    SignerDialog.this.passwordField.setEchoChar('*');
                    SignerDialog.this.passwordField.requestFocusInWindow();
                }
            }
        });
        this.showPwdBtn.setForeground(GUiConstants.BUTTON_FOREGROUND_COLOR);
        this.showPwdBtn.setFont(new Font("Tahoma", 0, 14));
        this.showPwdBtn.setContentAreaFilled(false);
        this.showPwdBtn.setOpaque(true);
        this.showPwdBtn.setBackground(GUiConstants.BUTTON_BACKGROUND_COLOR);
        this.showPwdBtn.setBounds(600, 59, 45, 20);
        this.showPwdBtn.addKeyListener(capsLockListener);
        return this.showPwdBtn;
    }

    private KeyListener getCapsLockListener(final JLabel warningText) {
        return new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                try {
                    warningText.setText("");
                    if (SignerDialog.this.getToolkit().getLockingKeyState(20)) {
                        warningText.setText(ProgramSettings.getInstance().getDictionary("label.warningMessage.capsLock"));
                    }
                    if (!(e.getKeyCode() >= 48 && e.getKeyCode() <= 57 || SignerDialog.this.getInputContext().getLocale().getLanguage().equals("en"))) {
                        if (!warningText.getText().equals("")) {
                            warningText.setText(warningText.getText() + "; ");
                        }
                        warningText.setText(warningText.getText() + ProgramSettings.getInstance().getDictionary("label.warningMessage.language"));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        };
    }

    private JLabel getWarningText() {
        JLabel warningText = new JLabel("");
        warningText.setFont(new Font("Tahoma", 0, 12));
        warningText.setForeground(Color.RED);
        warningText.setBounds(280, 80, 350, 14);
        return warningText;
    }

    private void addPasswordForm(KeyListener capsLockListener) {
        this.addLabel("label.enterPass", GUiConstants.LABEL_FOREGROUND_COLOR, new Rectangle(15, 61, 250, 14), this.contentPanel);
        this.passwordField = new JPasswordField();
        this.passwordField.enableInputMethods(true);
        this.passwordField.setFont(new Font("Tahoma", 0, 12));
        this.passwordField.setBounds(280, 59, 320, 20);
        this.contentPanel.add(this.passwordField);
        this.passwordField.setColumns(15);
        this.passwordField.requestFocusInWindow();
        this.passwordField.addKeyListener(capsLockListener);
    }

    private void addContainerTypeForm() {
        this.addLabel("label.signerDialog.containerType", GUiConstants.LABEL_FOREGROUND_COLOR, new Rectangle(15, 31, 250, 20), this.contentPanel);
        if (this.storageInfo.getStorage().isToken() && this.storageInfo.getContainers().size() > 1) {
            this.contentPanel.add(this.getContainerComboBox());
        } else {
            JLabel containerTypeText = new JLabel(this.storageInfo.getContainer());
            containerTypeText.setFont(new Font("Tahoma", 0, 12));
            containerTypeText.setBounds(280, 31, 350, 20);
            this.contentPanel.add(containerTypeText);
        }
    }

    private JComboBox getContainerComboBox() {
        this.containerComboBox = new JComboBox();
        this.containerComboBox.setBounds(280, 31, 320, 20);
        for (String container : this.storageInfo.getContainers()) {
            this.containerComboBox.addItem(container);
        }
        this.containerComboBox.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.storageInfo.setContainer((String)this.containerComboBox.getSelectedItem());
            }
        });
        return this.containerComboBox;
    }

    private void addStorageTypeForm() {
        this.addLabel("label.signerDialog.storageType", GUiConstants.LABEL_FOREGROUND_COLOR, new Rectangle(15, 11, 250, 14), this.contentPanel);
        JLabel storageTypeText = new JLabel(ProgramSettings.getInstance().getDictionary("label.signerDialog.storage." + this.storageInfo.getStorage().getName()));
        storageTypeText.setFont(new Font("Tahoma", 0, 12));
        storageTypeText.setBounds(280, 11, 350, 14);
        this.contentPanel.add(storageTypeText);
    }

    private void setDialogProperties() {
        this.setAlwaysOnTop(true);
        this.setModal(true);
        this.setTitle(ProgramSettings.getInstance().getDictionary(this.titles.containsKey("title") ? this.titles.get("title") : "label.signerDialog"));
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                SignerDialog.this.setVisible(false);
                SignerDialog.this.dispose();
            }
        });
        this.setFrameToScreenCenter();
        this.setResizable(false);
        this.pack();
    }

    public boolean getDoSign() {
        return this.doSign;
    }

    public KeyListEntry getSelectedItem() {
        return this.selectedItem;
    }

    private List<KeyListEntry> refreshKeyList() throws Exception {
        ArrayList<KeyListEntry> keys = null;
        try {
            KNCACertificateType kncaCertificateType;
            KeyStore ks = KeyStoreUtil.getKeyStore((Storage)this.storageInfo.getStorage(), (String)this.storageInfo.getContainer(), (char[])this.storageInfo.getPassword(), (Provider)BundleProvider.KALKAN.getProvider());
            Map entries = null;
            if (this.keyType == null) {
                kncaCertificateType = KNCACertificateType.SIGNATURE;
                entries = KeyStoreUtil.getKeyStoreEntries((KeyStore)ks, (char[])this.storageInfo.getPassword(), (KNCACertificateType)kncaCertificateType);
                kncaCertificateType = KNCACertificateType.AUTHENTICATION;
            } else {
                kncaCertificateType = this.keyType;
            }
            if (entries != null) {
                entries.putAll(KeyStoreUtil.getKeyStoreEntries((KeyStore)ks, (char[])this.storageInfo.getPassword(), (KNCACertificateType)kncaCertificateType));
            } else {
                entries = KeyStoreUtil.getKeyStoreEntries((KeyStore)ks, (char[])this.storageInfo.getPassword(), (KNCACertificateType)kncaCertificateType);
            }
            if (entries != null && !entries.isEmpty()) {
                keys = new ArrayList<KeyListEntry>();
                for (KeyStoreEntry kseKey : entries.values()) {
                    keys.add(new KeyListEntry(kseKey.getKeyId(), kseKey.getAlgorithm(), kseKey.getX509Certificate()));
                }
                Collections.sort(keys, new KeyListEntryComparator());
            }
        }
        catch (ProviderUtilException ex) {
            if (ex.getCode().equals((Object)ProviderUtilExceptionCode.WRONG_KEYSTORE_PASSWORD)) {
                if (ex.getTryCount() > -1) {
                    throw new ClientException(ProgramSettings.getInstance().getDictionary("label.errorMessage.incorrectPassWithTryCount") + ex.getTryCount());
                }
                throw new ClientException(ProgramSettings.getInstance().getDictionary("label.errorMessage.incorrectPass"));
            }
            if (ex.getCode().equals((Object)ProviderUtilExceptionCode.BLOCKED_KEYSTORE_PASSWORD)) {
                throw new ClientException(ProgramSettings.getInstance().getDictionary("label.errorMessage.blockedPass"));
            }
            throw new ClientException(ex.getMessage());
        }
        return keys;
    }

    private void initFooter() {
        JPanel footer = new JPanel();
        footer.setPreferredSize(new Dimension(660, 75));
        footer.setLayout(null);
        this.getContentPane().add((Component)footer, "South");
        JPanel mesPanel = new JPanel();
        mesPanel.setBorder(new EtchedBorder(1, null, null));
        mesPanel.setBounds(15, 0, 630, 60);
        mesPanel.setLayout(null);
        footer.add(mesPanel);
        this.mesLabel = new JLabel();
        this.mesLabel.setBounds(5, 0, 620, 60);
        this.mesLabel.setForeground(Color.RED);
        this.mesLabel.setFont(new Font("Tahoma", 0, 14));
        mesPanel.add(this.mesLabel);
    }

    private void initKeyListPanel() {
        String labelKey = this.keyType != null && this.keyType.equals((Object)KNCACertificateType.AUTHENTICATION) ? "label.signerDialog.chooseKeyAuth" : (this.keyType != null && this.keyType.equals((Object)KNCACertificateType.SIGNATURE) ? "label.signerDialog.chooseKeySign" : "label.signerDialog.chooseKey");
        this.keyListPanel = new JPanel();
        this.keyListPanel.setBounds(15, 144, 630, 252);
        this.keyListPanel.setLayout(null);
        this.addLabel(labelKey, GUiConstants.LABEL_FOREGROUND_COLOR, new Rectangle(0, 11, 224, 14), this.keyListPanel);
        this.keyInfoPanel = new JPanel();
        this.keyInfoPanel.setBorder(new TitledBorder(new LineBorder(new Color(120, 120, 120), 1), ProgramSettings.getInstance().getDictionary("label.signerDialog.keyInfo.title"), 4, 2, new Font("Tahoma", 1, 12), new Color(0, 0, 0)));
        this.keyInfoPanel.setBounds(0, 62, 630, 147);
        this.keyInfoPanel.setLayout(null);
        this.keyListPanel.add(this.keyInfoPanel);
        this.addLabel("label.signerDialog.keyInfo.algorithm", GUiConstants.LABEL_FOREGROUND_COLOR, new Rectangle(15, 122, 174, 14), this.keyInfoPanel);
        this.algNameText = this.addDynamicLabel(new Rectangle(185, 123, 430, 14), this.keyInfoPanel);
        this.addLabel("label.signerDialog.keyInfo.keyOwner", GUiConstants.LABEL_FOREGROUND_COLOR, new Rectangle(15, 22, 174, 14), this.keyInfoPanel);
        this.keyOwnerText = this.addDynamicLabel(new Rectangle(185, 23, 430, 14), this.keyInfoPanel);
        this.addLabel("label.signerDialog.keyInfo.serialNum", GUiConstants.LABEL_FOREGROUND_COLOR, new Rectangle(15, 72, 174, 14), this.keyInfoPanel);
        this.serialNumberText = this.addDynamicLabel(new Rectangle(185, 73, 440, 14), this.keyInfoPanel);
        this.addLabel("label.signerDialog.keyInfo.period", GUiConstants.LABEL_FOREGROUND_COLOR, new Rectangle(15, 47, 174, 14), this.keyInfoPanel);
        this.periodText = this.addDynamicLabel(new Rectangle(185, 48, 440, 14), this.keyInfoPanel);
        this.addLabel("label.signerDialog.keyInfo.issuer", GUiConstants.LABEL_FOREGROUND_COLOR, new Rectangle(15, 97, 174, 14), this.keyInfoPanel);
        this.issuerNameText = this.addDynamicLabel(new Rectangle(185, 98, 430, 14), this.keyInfoPanel);
        this.signLoadingJLabel = new JLabel();
        this.signLoadingJLabel.setIcon(this.loadingImage);
        this.signLoadingJLabel.setBounds(174, 217, 32, 32);
        this.keyListPanel.add(this.signLoadingJLabel);
        this.signLoadingJLabel.setVisible(false);
        this.keyListComboBox = new JComboBox();
        this.keyListComboBox.setBounds(0, 29, 630, 20);
        this.keyListComboBox.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.selectedItem = (KeyListEntry)((Object)((Object)this.keyListComboBox.getItemAt(this.keyListComboBox.getSelectedIndex())));
                this.fillSelectedKey();
            }
        });
        this.keyListPanel.add(this.keyListComboBox);
        this.signButton = this.addButton(this.titles.containsKey("actionBtn") ? this.titles.get("actionBtn") : "button.signerDialog.sign", GUiConstants.BUTTON_BACKGROUND_COLOR, new Rectangle(211, 215, 207, 35), this.keyListPanel);
        this.signButton.addActionListener(a -> {
            this.doSign = true;
            this.setVisible(false);
            this.dispose();
        });
        this.cancelButton = this.addButton("button.cancel", GUiConstants.BUTTON_BACKGROUND_COLOR, new Rectangle(423, 215, 207, 35), this.keyListPanel);
        this.cancelButton.addActionListener(a -> {
            this.setVisible(false);
            this.dispose();
        });
        this.contentPanel.add(this.keyListPanel);
        this.keyListPanel.setVisible(false);
    }

    private JLabel getRefreshLoadingJLabel() {
        this.refreshLoadingJLabel = new JLabel();
        this.loadingImage = new ImageIcon(SignerDialog.class.getClassLoader().getResource("loading.gif"));
        this.refreshLoadingJLabel.setIcon(this.loadingImage);
        this.refreshLoadingJLabel.setBounds(189, 88, 32, 32);
        this.refreshLoadingJLabel.setVisible(false);
        return this.refreshLoadingJLabel;
    }

    private void addLabel(String key, Color foregroundColor, Rectangle rectangle, JPanel paretnt) {
        JLabel label = key == null ? new JLabel() : new JLabel(ProgramSettings.getInstance().getDictionary(key));
        label.setFont(new Font("Tahoma", 0, 12));
        label.setForeground(foregroundColor);
        label.setBounds(rectangle);
        paretnt.add(label);
    }

    private JLabel addDynamicLabel(Rectangle rectangle, JPanel paretnt) {
        JLabel label = new JLabel();
        label.setFont(new Font("Tahoma", 0, 12));
        label.setForeground(GUiConstants.BLACK_FOREGROUND_COLOR);
        label.setBounds(rectangle);
        paretnt.add(label);
        return label;
    }

    private JButton addButton(String key, Color backgroundColor, Rectangle rectangle, JPanel paretnt) {
        JButton button = new JButton(ProgramSettings.getInstance().getDictionary(key));
        button.setContentAreaFilled(false);
        button.setOpaque(true);
        button.setForeground(GUiConstants.BUTTON_FOREGROUND_COLOR);
        button.setFont(new Font("Tahoma", 0, 14));
        button.setBackground(backgroundColor);
        button.setBounds(rectangle);
        button.setBorderPainted(false);
        paretnt.add(button);
        return button;
    }

    private void blockRefreshPart() {
        this.refreshLoadingJLabel.setVisible(true);
        this.passwordField.setEnabled(false);
        this.showPwdBtn.setEnabled(false);
        if (this.containerComboBox != null) {
            this.containerComboBox.setEnabled(false);
        }
        this.refreshKeyListButton.setEnabled(false);
        this.refreshKeyListButton.setBackground(new Color(180, 180, 180));
        this.canButton.setEnabled(false);
        this.canButton.setBackground(new Color(180, 180, 180));
        this.contentPanel.repaint();
        this.contentPanel.revalidate();
    }

    private void unblockRefreshPart() {
        this.refreshLoadingJLabel.setVisible(false);
        this.passwordField.setEnabled(true);
        this.showPwdBtn.setEnabled(true);
        if (this.containerComboBox != null) {
            this.containerComboBox.setEnabled(true);
        }
        this.refreshKeyListButton.setEnabled(true);
        this.refreshKeyListButton.setBackground(GUiConstants.BUTTON_BACKGROUND_COLOR);
        this.canButton.setEnabled(true);
        this.canButton.setBackground(GUiConstants.BUTTON_BACKGROUND_COLOR);
    }

    private void updateKeyList(List<KeyListEntry> keys) {
        this.keyListComboBox.removeAllItems();
        for (KeyListEntry key : keys) {
            this.keyListComboBox.addItem(key);
        }
        this.selectedItem = (KeyListEntry)((Object)this.keyListComboBox.getItemAt(0));
        this.fillSelectedKey();
    }

    private void fillSelectedKey() {
        this.algNameText.setText(this.selectedItem.getAlgorithm());
        this.storageInfo.setAlias(this.selectedItem.getKeyId());
        if (this.selectedItem.getX509Certificate() != null) {
            this.keyOwnerText.setText(this.selectedItem.getSubjectCn());
            this.periodText.setText(this.selectedItem.getPeriod());
            this.serialNumberText.setText(this.selectedItem.getSerialNumber());
            this.issuerNameText.setText(this.selectedItem.getIssuerCn());
            this.signButton.setVisible(true);
            if (this.selectedItem.expired) {
                this.setMessage(ProgramSettings.getInstance().getDictionary("label.errorMessage.expired"));
            } else {
                this.setMessage("");
            }
        } else {
            this.keyOwnerText.setText("\u2014");
            this.periodText.setText("\u2014");
            this.serialNumberText.setText("\u2014");
            this.issuerNameText.setText("\u2014");
            this.signButton.setVisible(false);
            this.setMessage(ProgramSettings.getInstance().getDictionary("label.message.certificateNotFound"));
        }
    }

    protected void setMessage(String message) {
        this.mesLabel.setText("<html><p>" + message + "</p></html>");
    }

    private void setFrameToScreenCenter() {
        Dimension d = this.getToolkit().getScreenSize();
        this.setLocation(d.width / 2 - this.getPreferredSize().width / 2, d.height / 2 - (this.getPreferredSize().height + 232) / 2);
    }

    private class KeyListEntry
    extends KeyStoreEntry {
        private String period;
        private boolean expired;

        public KeyListEntry(String keyId, String algorithm, X509Certificate x509Certificate) throws CertificateException {
            super(keyId, algorithm, x509Certificate);
            this.expired = false;
            if (x509Certificate != null) {
                this.period = this.parseDateToString(x509Certificate.getNotBefore()) + " - " + this.parseDateToString(x509Certificate.getNotAfter());
                try {
                    x509Certificate.checkValidity();
                }
                catch (CertificateExpiredException | CertificateNotYetValidException e) {
                    this.expired = true;
                }
            }
        }

        public String getPeriod() {
            return this.period;
        }

        public void setPeriod(String period) {
            this.period = period;
        }

        public boolean isExpired() {
            return this.expired;
        }

        public void setExpired(boolean expired) {
            this.expired = expired;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getAlgorithm()).append("<@>");
            if (this.getX509Certificate() == null) {
                sb.append("\u2014").append("<@>");
                sb.append(this.getKeyId());
            } else {
                sb.append(this.getSubjectCn()).append("<@>");
                sb.append(this.period).append("<@>");
                sb.append(this.getKeyId()).append("<@>");
                sb.append(this.getSerialNumber()).append("<@>");
                sb.append(this.getIssuerCn()).append("<@>");
            }
            return sb.toString();
        }

        private String parseDateToString(Date date) {
            if (date == null) {
                return null;
            }
            String pattern = "dd.MM.yyyy (HH:mm)";
            SimpleDateFormat df = new SimpleDateFormat(pattern);
            df.setTimeZone(TimeZone.getTimeZone("Asia/Almaty"));
            return df.format(date);
        }
    }

    private class KeyListEntryComparator
    implements Comparator<KeyStoreEntry> {
        private KeyListEntryComparator() {
        }

        @Override
        public int compare(KeyStoreEntry o1, KeyStoreEntry o2) {
            if (o1.getX509Certificate() == null && o2.getX509Certificate() == null) {
                return 0;
            }
            if (o1.getX509Certificate() != null && o2.getX509Certificate() == null) {
                return -1;
            }
            if (o1.getX509Certificate() == null && o2.getX509Certificate() != null) {
                return 1;
            }
            return o2.getX509Certificate().getNotBefore().compareTo(o1.getX509Certificate().getNotBefore());
        }
    }
}

