/*
 * Decompiled with CFR 0.152.
 */
package kz.uchet.signUtil.gui.fx;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.security.KeyStore;
import java.security.Provider;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import kz.gov.pki.kalkan.Storage;
import kz.gov.pki.provider.exception.ProviderUtilException;
import kz.gov.pki.provider.exception.ProviderUtilExceptionCode;
import kz.gov.pki.provider.utils.KeyStoreUtil;
import kz.uchet.signUtil.BundleLog;
import kz.uchet.signUtil.BundleProvider;
import kz.uchet.signUtil.types.ClientException;
import kz.uchet.signUtil.types.FileExtension;
import kz.uchet.signUtil.types.StorageInfo;

public class JavaFXThread {
    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    Font font = new Font("Arial", 15.0);
    Locale locale;

    public JavaFXThread(Locale locale) {
        this.locale = locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void fillStorageInfo(StorageInfo storageInfo) {
        Stage stage = new Stage();
        VBox vBox = this.buildStage(stage);
        GridPane gridPane = this.createFormPane();
        this.addUIControls(gridPane, stage, storageInfo);
        vBox.getChildren().addAll((Object[])new Node[]{gridPane});
        stage.showAndWait();
    }

    private void addUIControls(GridPane gridPane, Stage stage, StorageInfo storageInfo) {
        Label headerLabel = new Label(this.getMessage("storage"));
        headerLabel.setFont(Font.font((String)"Arial", (FontWeight)FontWeight.BOLD, (double)24.0));
        gridPane.add((Node)headerLabel, 0, 0, 2, 1);
        GridPane.setHalignment((Node)headerLabel, (HPos)HPos.CENTER);
        GridPane.setMargin((Node)headerLabel, (Insets)new Insets(20.0, 0.0, 20.0, 0.0));
        Label nameLabel = new Label(this.getMessage("storage.path"));
        gridPane.add((Node)nameLabel, 0, 1);
        if (storageInfo.getStorage().isToken()) {
            ObservableList options = FXCollections.observableArrayList(storageInfo.getContainers());
            ComboBox containerComboBox = new ComboBox(options);
            containerComboBox.setOnAction(e -> storageInfo.setContainer((String)containerComboBox.getSelectionModel().getSelectedItem()));
            containerComboBox.getSelectionModel().selectFirst();
            storageInfo.setContainer((String)containerComboBox.getSelectionModel().getSelectedItem());
            gridPane.add((Node)containerComboBox, 1, 1);
        } else {
            TextField containerField = new TextField();
            containerField.setDisable(true);
            Button fileBtn = new Button(this.getMessage("btn.choose") + "..");
            fileBtn.setOnAction(e -> {
                File f = this.getFile("", FileExtension.pkcs12, stage);
                if (f != null) {
                    containerField.setText(f.getPath());
                    storageInfo.setContainer(f.getPath());
                }
            });
            HBox hb = new HBox();
            hb.setSpacing(1.0);
            Object[] obj = new Node[]{containerField, fileBtn};
            hb.getChildren().addAll(obj);
            HBox.setHgrow((Node)containerField, (Priority)Priority.ALWAYS);
            gridPane.add((Node)hb, 1, 1);
        }
        Label passwordLabel = new Label(this.getMessage("pwd"));
        gridPane.add((Node)passwordLabel, 0, 2);
        PasswordField passwordField = new PasswordField();
        gridPane.add((Node)passwordField, 1, 2);
        Button submitButton = new Button(this.getMessage("open"));
        submitButton.setDefaultButton(true);
        submitButton.setPrefWidth(100.0);
        gridPane.add((Node)submitButton, 0, 3, 2, 1);
        GridPane.setHalignment((Node)submitButton, (HPos)HPos.CENTER);
        GridPane.setMargin((Node)submitButton, (Insets)new Insets(10.0, 0.0, 10.0, 0.0));
        submitButton.setOnAction(e -> {
            storageInfo.setPassword(passwordField.getText().toCharArray());
            System.out.println("pass = " + passwordField.getText());
            if (storageInfo.getContainer() == null || storageInfo.getPassword() == null || storageInfo.getPassword().length == 0) {
                this.showAlert(Alert.AlertType.ERROR, (Window)stage, this.getMessage("error"), this.getMessage("error.empty"));
                return;
            }
            try {
                storageInfo.setKeyStore(this.getKeyStore(storageInfo));
            }
            catch (Exception exception) {
                this.showAlert(Alert.AlertType.ERROR, (Window)stage, this.getMessage("error"), exception.getMessage());
                return;
            }
            stage.close();
        });
    }

    private KeyStore getKeyStore(StorageInfo storageInfo) throws Exception {
        try {
            System.out.println("getKeyStore storageInfo " + storageInfo.toString());
            return KeyStoreUtil.getKeyStore((Storage)storageInfo.getStorage(), (String)storageInfo.getContainer(), (char[])storageInfo.getPassword(), (Provider)BundleProvider.KALKAN.getProvider());
        }
        catch (ProviderUtilException e) {
            BundleLog.LOG.log(1, e.getMessage(), e);
            if (e.getCode().equals((Object)ProviderUtilExceptionCode.WRONG_KEYSTORE_PASSWORD)) {
                String msg = this.getMessage("pwd.wrongPin");
                if (e.getTryCount() > -1) {
                    msg = msg + " " + this.getMessage("pwd.retryCount") + " " + String.valueOf(e.getTryCount());
                }
                throw new ClientException(msg);
            }
            if (e.getCode().equals((Object)ProviderUtilExceptionCode.BLOCKED_KEYSTORE_PASSWORD)) {
                throw new ClientException(this.getMessage("pwd.blocked"));
            }
            throw new ClientException(e.getMessage());
        }
    }

    private void showAlert(Alert.AlertType alertType, Window owner, String title, String message) {
        Alert alert = new Alert(alertType);
        alert.setTitle(title);
        alert.setHeaderText((String)null);
        alert.setContentText(message);
        alert.initOwner(owner);
        alert.show();
    }

    private GridPane createFormPane() {
        GridPane gridPane = new GridPane();
        gridPane.setAlignment(Pos.CENTER);
        gridPane.setPadding(new Insets(1.0, 1.0, 1.0, 1.0));
        gridPane.setHgap(10.0);
        gridPane.setVgap(10.0);
        ColumnConstraints columnOneConstraints = new ColumnConstraints(150.0, 150.0, Double.MAX_VALUE);
        columnOneConstraints.setHalignment(HPos.RIGHT);
        ColumnConstraints columnTwoConstrains = new ColumnConstraints(200.0, 200.0, Double.MAX_VALUE);
        columnTwoConstrains.setHgrow(Priority.ALWAYS);
        return gridPane;
    }

    private VBox buildStage(Stage stage) {
        stage.setAlwaysOnTop(true);
        stage.setTitle("EzSigner");
        VBox vbox = new VBox();
        vbox.setSpacing(5.0);
        vbox.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        Group root = new Group();
        BorderPane borderPane = new BorderPane();
        BorderPane.setMargin((Node)vbox, (Insets)new Insets(20.0, 5.0, 15.0, 5.0));
        borderPane.setCenter((Node)vbox);
        Scene scene = new Scene((Parent)root, 500.0, 250.0);
        scene.setRoot((Parent)borderPane);
        stage.setScene(scene);
        stage.setResizable(false);
        stage.centerOnScreen();
        return vbox;
    }

    public File getFile(String initialFilePath, FileExtension fileExtension) {
        Stage stage = this.showTransporentStage();
        File f = this.getFile(initialFilePath, fileExtension, stage);
        stage.close();
        return f;
    }

    public File getFile(String initialFilePath, FileExtension fileExtension, Stage stage) {
        File initialDir;
        FileChooser fileChooser = new FileChooser();
        if (fileExtension != null && !fileExtension.equals((Object)FileExtension.all)) {
            FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter(fileExtension.getDesc(), fileExtension.getExts());
            fileChooser.getExtensionFilters().add((Object)extFilter);
        }
        if (initialFilePath != null && !initialFilePath.trim().isEmpty() && Files.exists((initialDir = new File(initialFilePath)).toPath(), new LinkOption[0])) {
            fileChooser.setInitialDirectory(initialDir);
        }
        fileChooser.setTitle(this.getMessage("key.choose"));
        return fileChooser.showOpenDialog((Window)stage);
    }

    public File getDirectoryPath(String initialFilePath) {
        File initialDir;
        DirectoryChooser dirChooser = new DirectoryChooser();
        dirChooser.setTitle(this.getMessage("dir.choose"));
        if (initialFilePath != null && !initialFilePath.trim().isEmpty() && Files.exists((initialDir = new File(initialFilePath)).toPath(), new LinkOption[0])) {
            dirChooser.setInitialDirectory(initialDir);
        }
        Stage stage = this.showTransporentStage();
        File f = dirChooser.showDialog((Window)stage);
        stage.close();
        return f;
    }

    private Stage showTransporentStage() {
        Stage stage = new Stage();
        stage.setWidth(10.0);
        stage.setHeight(10.0);
        stage.setAlwaysOnTop(true);
        stage.initStyle(StageStyle.TRANSPARENT);
        stage.centerOnScreen();
        stage.show();
        return stage;
    }

    public String getMessage(String key) {
        return ResourceBundle.getBundle("i18n.dictionary", this.locale).getString(key);
    }
}

